#
# rossler.py
#
"""
This module holds the Rossler system definitions
"""

def v(x,t,p):
	"""
	Velocity function of Rossler system.
	x: vector of coordinates x = [x,y,z]
	t: time
	p: vector of parameters p = [a,b,c]
	"""
	x,y,z = x
	a,b,c = p
	
	velocity = [-y - z,
				x + a*y,
				b + z*(x-c)]

	return velocity
